/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Range;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataSource;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.InstanceListener;
import weka.gui.beans.KFStep;
import weka.gui.beans.StreamThroughput;
import weka.gui.beans.Visible;

@KFStep(category="Tools", toolTipText="Replace substrings in String attributes")
public class SubstringReplacer
extends JPanel
implements BeanCommon,
Visible,
Serializable,
InstanceListener,
EventConstraints,
EnvironmentHandler,
DataSource {
    private static final long serialVersionUID = 5636877747903965818L;
    protected transient Environment m_env;
    protected String m_matchReplaceDetails = "";
    protected transient List<MatchReplace> m_mr;
    protected transient Logger m_log;
    protected transient boolean m_busy;
    protected Object m_listenee;
    protected ArrayList<InstanceListener> m_instanceListeners = new ArrayList();
    protected InstanceEvent m_ie = new InstanceEvent(this);
    protected BeanVisual m_visual = new BeanVisual("SubstringReplacer", "weka/gui/beans/icons/DefaultFilter.gif", "weka/gui/beans/icons/DefaultFilter_animated.gif");
    protected transient StreamThroughput m_throughput;

    public SubstringReplacer() {
        this.useDefaultVisual();
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
        this.m_env = Environment.getSystemWide();
    }

    public String globalInfo() {
        return "Replaces substrings in String attribute values using either literal match and replace or regular expression matching. The attributesto apply the match and replace rules to can be selected via a range string (e.g 1-5,6,last) or by a comma separated list of attribute names (/first and /last can be used to indicate the first and last attribute respectively)";
    }

    public void setMatchReplaceDetails(String details) {
        this.m_matchReplaceDetails = details;
    }

    public String getMatchReplaceDetails() {
        return this.m_matchReplaceDetails;
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        if (this.m_listenee == null) {
            return false;
        }
        if (!eventName.equals("instance")) {
            return false;
        }
        return !(this.m_listenee instanceof EventConstraints) || ((EventConstraints)this.m_listenee).eventGeneratable(eventName);
    }

    @Override
    public synchronized void acceptInstance(InstanceEvent e) {
        this.m_busy = true;
        if (e.getStatus() == 0) {
            this.m_throughput = new StreamThroughput(this.statusMessagePrefix());
            Instances structure = e.getStructure();
            this.m_mr = new ArrayList<MatchReplace>();
            if (this.m_matchReplaceDetails != null && this.m_matchReplaceDetails.length() > 0) {
                String[] mrParts;
                String[] stringArray = mrParts = this.m_matchReplaceDetails.split("@@match-replace@@");
                int n = mrParts.length;
                int n2 = 0;
                while (n2 < n) {
                    String p = stringArray[n2];
                    MatchReplace mr = new MatchReplace(p.trim());
                    mr.m_statusMessagePrefix = this.statusMessagePrefix();
                    mr.m_logger = this.m_log;
                    mr.init(this.m_env, structure);
                    this.m_mr.add(mr);
                    ++n2;
                }
            }
            if (!e.m_formatNotificationOnly && this.m_log != null) {
                this.m_log.statusMessage(String.valueOf(this.statusMessagePrefix()) + "Processing stream...");
            }
            this.m_ie.setStructure(structure);
            this.m_ie.m_formatNotificationOnly = e.m_formatNotificationOnly;
            this.notifyInstanceListeners(this.m_ie);
        } else {
            Instance inst = e.getInstance();
            if (inst != null) {
                this.m_throughput.updateStart();
                for (MatchReplace mr : this.m_mr) {
                    mr.apply(inst);
                }
                this.m_throughput.updateEnd(this.m_log);
            }
            this.m_ie.setInstance(inst);
            this.m_ie.setStatus(e.getStatus());
            this.notifyInstanceListeners(this.m_ie);
            if (e.getStatus() == 2 || inst == null) {
                this.m_throughput.finished(this.m_log);
            }
        }
        this.m_busy = false;
    }

    @Override
    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/DefaultFilter.gif", "weka/gui/beans/icons/DefaultFilter_animated.gif");
        this.m_visual.setText("SubstringReplacer");
    }

    @Override
    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    @Override
    public BeanVisual getVisual() {
        return this.m_visual;
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    @Override
    public void stop() {
        if (this.m_listenee != null && this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
        if (this.m_log != null) {
            this.m_log.statusMessage(String.valueOf(this.statusMessagePrefix()) + "Stopped");
        }
        this.m_busy = false;
    }

    @Override
    public boolean isBusy() {
        return this.m_busy;
    }

    @Override
    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    @Override
    public boolean connectionAllowed(EventSetDescriptor esd) {
        return this.connectionAllowed(esd.getName());
    }

    @Override
    public boolean connectionAllowed(String eventName) {
        if (!eventName.equals("instance")) {
            return false;
        }
        return this.m_listenee == null;
    }

    @Override
    public void connectionNotification(String eventName, Object source) {
        if (this.connectionAllowed(eventName)) {
            this.m_listenee = source;
        }
    }

    @Override
    public void disconnectionNotification(String eventName, Object source) {
        if (source == this.m_listenee) {
            this.m_listenee = null;
        }
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    protected String statusMessagePrefix() {
        return String.valueOf(this.getCustomName()) + "$" + this.hashCode() + "|";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyInstanceListeners(InstanceEvent e) {
        List l;
        SubstringReplacer substringReplacer = this;
        synchronized (substringReplacer) {
            l = (List)this.m_instanceListeners.clone();
        }
        if (l.size() > 0) {
            for (InstanceListener il : l) {
                il.acceptInstance(e);
            }
        }
    }

    @Override
    public synchronized void addInstanceListener(InstanceListener tsl) {
        this.m_instanceListeners.add(tsl);
    }

    @Override
    public synchronized void removeInstanceListener(InstanceListener tsl) {
        this.m_instanceListeners.remove(tsl);
    }

    @Override
    public void addDataSourceListener(DataSourceListener dsl) {
    }

    @Override
    public void removeDataSourceListener(DataSourceListener dsl) {
    }

    protected static class MatchReplace {
        protected String m_match = "";
        protected String m_replace = "";
        protected boolean m_regex;
        protected Pattern m_regexPattern;
        protected boolean m_ignoreCase;
        protected String m_attsToApplyTo = "";
        protected String m_matchS;
        protected String m_replaceS;
        protected int[] m_selectedAtts;
        protected String m_statusMessagePrefix;
        protected Logger m_logger;

        public MatchReplace() {
        }

        public MatchReplace(String setup) {
            this.parseFromInternal(setup);
        }

        public MatchReplace(String match, String replace, boolean regex, boolean ignoreCase, String selectedAtts) {
            this.m_match = match;
            this.m_replace = replace;
            this.m_regex = regex;
            this.m_ignoreCase = ignoreCase;
            this.m_attsToApplyTo = selectedAtts;
        }

        protected void parseFromInternal(String setup) {
            String[] parts = setup.split("@@MR@@");
            if (parts.length < 4 || parts.length > 5) {
                throw new IllegalArgumentException("Malformed match-replace definition: " + setup);
            }
            this.m_attsToApplyTo = parts[0].trim();
            this.m_regex = parts[1].trim().toLowerCase().equals("t");
            this.m_ignoreCase = parts[2].trim().toLowerCase().equals("t");
            this.m_match = parts[3].trim();
            if (this.m_match == null || this.m_match.length() == 0) {
                throw new IllegalArgumentException("Must provide something to match!");
            }
            if (parts.length == 5) {
                this.m_replace = parts[4];
            }
        }

        public void setMatch(String match) {
            this.m_match = match;
        }

        public String getMatch() {
            return this.m_match;
        }

        public void setReplace(String replace) {
            this.m_replace = replace;
        }

        public String getReplace() {
            return this.m_replace;
        }

        public void setRegex(boolean regex) {
            this.m_regex = regex;
        }

        public boolean getRegex() {
            return this.m_regex;
        }

        public void setIgnoreCase(boolean ignore) {
            this.m_ignoreCase = ignore;
        }

        public boolean getIgnoreCase() {
            return this.m_ignoreCase;
        }

        public void setAttsToApplyTo(String a) {
            this.m_attsToApplyTo = a;
        }

        public String getAttsToApplyTo() {
            return this.m_attsToApplyTo;
        }

        public void init(Environment env, Instances structure) {
            HashSet<Integer> indexes;
            this.m_matchS = this.m_match;
            this.m_replaceS = this.m_replace;
            String attsToApplyToS = this.m_attsToApplyTo;
            try {
                this.m_matchS = env.substitute(this.m_matchS);
                this.m_replaceS = env.substitute(this.m_replace);
                attsToApplyToS = env.substitute(attsToApplyToS);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.m_regex) {
                String match = this.m_matchS;
                if (this.m_ignoreCase) {
                    match = match.toLowerCase();
                }
                this.m_regexPattern = Pattern.compile(match);
            }
            String tempRangeS = attsToApplyToS;
            tempRangeS = tempRangeS.replace("/first", "first").replace("/last", "last");
            Range tempR = new Range();
            tempR.setRanges(attsToApplyToS);
            try {
                tempR.setUpper(structure.numAttributes() - 1);
                this.m_selectedAtts = tempR.getSelection();
            }
            catch (IllegalArgumentException ex) {
                this.m_selectedAtts = null;
            }
            if (this.m_selectedAtts == null) {
                String[] attParts;
                indexes = new HashSet<Integer>();
                String[] stringArray = attParts = this.m_attsToApplyTo.split(",");
                int n = attParts.length;
                int n2 = 0;
                while (n2 < n) {
                    String att = stringArray[n2];
                    if ((att = att.trim()).toLowerCase().equals("/first")) {
                        indexes.add(0);
                    } else if (att.toLowerCase().equals("/last")) {
                        indexes.add(structure.numAttributes() - 1);
                    } else if (structure.attribute(att) != null) {
                        indexes.add(new Integer(structure.attribute(att).index()));
                    } else if (this.m_logger != null) {
                        String msg = String.valueOf(this.m_statusMessagePrefix) + "Can't find attribute '" + att + "in the incoming instances - ignoring";
                        this.m_logger.logMessage(msg);
                    }
                    ++n2;
                }
                this.m_selectedAtts = new int[indexes.size()];
                int c = 0;
                for (Integer i : indexes) {
                    this.m_selectedAtts[c++] = i;
                }
            }
            indexes = new HashSet();
            int i = 0;
            while (i < this.m_selectedAtts.length) {
                if (structure.attribute(this.m_selectedAtts[i]).isString()) {
                    indexes.add(this.m_selectedAtts[i]);
                } else if (this.m_logger != null) {
                    String msg = String.valueOf(this.m_statusMessagePrefix) + "Attribute '" + structure.attribute(this.m_selectedAtts[i]).name() + "is not a string attribute - " + "ignoring";
                    this.m_logger.logMessage(msg);
                }
                ++i;
            }
            this.m_selectedAtts = new int[indexes.size()];
            int c = 0;
            for (Integer i2 : indexes) {
                this.m_selectedAtts[c++] = i2;
            }
        }

        public void apply(Instance inst) {
            int i = 0;
            while (i < this.m_selectedAtts.length) {
                int numStringVals = inst.attribute(this.m_selectedAtts[i]).numValues();
                if (!inst.isMissing(this.m_selectedAtts[i])) {
                    String value = inst.stringValue(this.m_selectedAtts[i]);
                    value = this.apply(value);
                    inst.dataset().attribute(this.m_selectedAtts[i]).setStringValue(value);
                    if (numStringVals > 1) {
                        inst.setValue(this.m_selectedAtts[i], 0.0);
                    }
                }
                ++i;
            }
        }

        protected String apply(String source) {
            String result = source;
            String match = this.m_matchS;
            if (this.m_ignoreCase) {
                result = result.toLowerCase();
                match = match.toLowerCase();
            }
            if (result != null && result.length() > 0) {
                result = this.m_regex ? this.m_regexPattern.matcher(result).replaceAll(this.m_replaceS) : result.replace(match, this.m_replaceS);
            }
            return result;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append(this.m_regex ? "Regex: " : "Substring: ");
            buff.append(this.m_match).append(" --> ").append(this.m_replace).append("  ");
            buff.append(this.m_ignoreCase ? "[ignore case]" : "").append("  ");
            buff.append("[Atts: " + this.m_attsToApplyTo + "]");
            return buff.toString();
        }

        protected String toStringInternal() {
            StringBuffer buff = new StringBuffer();
            buff.append(this.m_attsToApplyTo).append("@@MR@@");
            buff.append(this.m_regex ? "t" : "f").append("@@MR@@");
            buff.append(this.m_ignoreCase ? "t" : "f").append("@@MR@@");
            buff.append(this.m_match).append("@@MR@@");
            buff.append(this.m_replace);
            return buff.toString();
        }
    }
}

